//
//  BPAbstractLoginWindow.h
//  BIApp
//
//  Created by Brent Gulanowski on 11-01-12.
//  Copyright 2011 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import <MCApplication/MCWindowController.h>


extern NSString *kMCAccessAddress;
extern NSString *kMCConnectionInfo;


@class MCSService;

@interface BPAbstractLoginWindow : MCWindowController {

    MCSService *selectedServer;
	
	IBOutlet NSTextField *usernameField;
	IBOutlet NSTextField *cloudField;
	IBOutlet NSTextField *addressField;
	
	NSDate *trialExpiry;
	
    NSString *username;
    NSString *password;
    NSString *account;
    NSString *server;
    
	BOOL loggingIn;
	
	// for testing
	BOOL suppressAlerts;
	NSError *lastError;
}

@property(nonatomic,retain)MCSService *selectedServer;

@property(nonatomic, retain) NSDate *trialExpiry;

@property(nonatomic, retain) NSString *account;
@property(nonatomic, retain) NSString *server;
@property(nonatomic, retain) NSString *username;
@property(nonatomic, retain) NSString *password;

@property(nonatomic) BOOL loggingIn; // Bind view state to this

@property BOOL suppressAlerts;
@property (retain) NSError *lastError;

// username and password must be set before trying to login
// selectedServer must be set
- (void)performLogin;

// requires account to be set
- (void)loginViaCloud;
// requires selectedServer or server to be set
- (void)loginDirectly;

- (BOOL)enoughDetailsToLogin;

// arguments: accessAddress: address where accessd service was found; connectionInfo: dictionary returned by accessservice
// we execute this as a delayed perform, and can only support 1 argument; don't want to add properties b/c they could get stale
- (void)createOfflineWithArguments:(NSDictionary*)arguments;

// Subclasses
- (void)loginFailed;
- (BOOL)shouldCreateOffline;
- (void)finishedCreatingOffline;
- (void)offlineCreationFailed;
- (void)showProgress;

@end
